﻿<?LassoScript

	// Lasso Programming Challenge
	// <http://www.lassosoft.com/community/challenge/>
	//
	// Your Name - Bil Corry
	// Email Address - bil AT corry DOT biz
	//
	// Regular Expression Challenge
	// <http://www.lassosoft.com/community/challenge/index.lasso?9294>
	//
	// See the URL above for complete details about this programming
	// challenge including the end date, goals, judging criteria, and
	// prizes.
	//
	// Instructions
	//
	// Complete the challenge by modifying the code in this file to meet
	// the goals.  You can make any modifications to this file that you
	// see fit and you can use includes if necessary.  Please include
	// the challenge name, your name and email address in any files you
	// submit.  To enter, all files should be placed in a single folder,
	// zip compressed, and sent as an email attachment to:
	//
	// <challenge@lassosoft.com>
	//
	
	// This tag is used to provide access to the ldml8_reference database.
	Auth_Admin;

?><html>
	<head>
		<title>Lasso Coding Challenge - Regular Expression Challenge</title>
		<style>
			body { font-family: Verdana; font-size: 10px; width: 576px; }
			p,td { font-family: Verdana; font-size: 10px; }
			th { font-family: Verdana; font-weight: bold; font-size: 10px; text-align: left; }
			h1 { font-family: Verdana; font-weight: bold; font-size: 15px; }
			hr { border: 2px solid #cccccc; }
			h1 a { text-decoration: none; color: black; }
		</style>
	</head>
	<body>
		<h1><a href="http://www.lassosoft.com/"><img src="http://www.lassosoft.com/_images/lassosoft_logo.png" align="right" width="208" height="57" border="0" /></a><a href="http://www.lassosoft.com/community/challenge/">Lasso Coding Challenge - Regular Expression Challenge</a></h1>

		<p>This challenge is divided into eight problems.  Each problem
		can be solved using the regular expression tags in Lasso.  Many
		of the problems can be solved using ['[String_ReplaceRegExp]'] and
		['[String_FindRegExp]'].  Some of the problems may require advanced
		regular expression features or the ['[RegExp]'] type from Lasso
		8.5.</p>
		
		<p>The entry with the most correct answers will be the grand
		prize winner.  Ties will be decided based on the speed and
		elegance of the answers, or by random drawing.</p>
		
		<p>Everybody who answers one or more of the problems will be
		eligible to win a prize.  Please feel free to send in your entry
		even if you were not able to complete all of the problems.  A
		runner up will be selected from among all entries who have at
		least one correct answer.</p>
		
		<p>The source code of this document contains important
		additional details and placeholders for your answers.</p>
		
		<p>See the URL <a
		href="http://www.lassosoft.com/community/challenge/index.lasso?
		9294">http://www.lassosoft.com/community/challenge/index.lasso?
		9294</a> for important details about this challenge and complete
		rules.</p>
		
		<hr />
		
		<h2>1 - Phone Numbers</h2>
		
		<p>Reformat phone numbers from the (###) ###-#### format to read
		as ###-###-####.  For example, the phone numbers (800) 555-1212
		should be formatted as 800-555-1212.  Phone numbers in other
		formats should not be modified.</p>
		
		<?LassoScript
		
			var: 'originalText' = 'The number for toll free assistance \
			is (800) 555-1212.  LassoSoft’s local phone number is (954) \
			302-3526 and their toll free telephone number is \
			1-888-286-7753.';
			
			var: 'answerText' = '';
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
			$answerText = (string_replaceregexp: $originalText, -find='\\((\\d\\d\\d)\\) (\\d\\d\\d)\\-(\\d\\d\\d\\d)', -replace='\\1-\\2-\\3', -ignorecase);
			
		?>
		
		<p style="color: blue"><b>Original Text:</b> [Encode_HTML: $originalText]</p>
		<p style="color: red"><b>Answer:</b> [Encode_HTML: $answerText]</p>
		
		<hr />
		
		<h2>2 - White Space</h2>
		
		<p>Simplify the white space within a string.  Replace all
		sequences of white space which contain either a return \r or a
		newline \n with a single return/newline \r\n.  Replace all other
		sequences of whitespace with a single space.  White space
		includes at minimum returns \r, newlines \n, tabs \t, and
		spaces.</p>
		
		<?LassoScript
		
			var: 'originalText' = 'The   quick brown		fox 	\
			jumps		over a lazy 	 dog. 
			
\			The      five  boxing\twizards\tjump quickly.
			
\			My faxed          joke \t won a \t\
			pager      in   the  cable\tTV           quiz    show.';
			
			var: 'answerText' = '';
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
			$answerText = (string_replaceregexp: $originalText, -find='(\r\n)+|\r+|\n+', -replace='%RETURN%', -ignorecase);
			$answerText = (string_replaceregexp: $answerText, -find='\\s+', -replace=' ', -ignorecase);
			$answerText = (string_replaceregexp: $answerText, -find='(\\s*(%RETURN%)+\\s*)+', -replace='\r\n', -ignorecase);
			
		?>
		
		<p style="color: blue"><b>Original Text:</b> <pre style="color: blue">[Encode_HTML: $originalText]</pre></p>
		<p style="color: red"><b>Answer:</b> <pre style="color: red">[Encode_HTML: $answerText]</pre></p>
		<p style="color: red"><b>URL-Encoded Answer:</b> <pre style="color: red">[Encode_URL: $answerText]</pre></p>
		<hr />
		
		<h2>3 - Remove Duplicate Lines</h2>
		
		<p>Find and remove duplicates lines from a block of text.  The lines have
		already been sorted into alphabetical order so you know duplicates will
		be adjacent. Each line ends with a return/newline \r\n pair.</p>
		
		<?LassoScript
		
			var: 'originalText' = 'Claire Bennet\r\nD.L. Hawkins\r\n\
			Isaac Mendez\r\nMatt Parkman\r\nMatt Parkman\r\n\
			Micah Sanders\r\nMohinder Suresh\r\nMohinder Suresh\r\n\
			Mohinder Suresh\r\nMohinder Suresh\r\nNiki Sanders\r\n\
			Noah Bennet\r\nPeter Petrelli\r\nPeter Petrelli\r\n\
			Simone Deveaux\r\nSimone Deveaux\r\nSimone Deveaux';
			
			var: 'answerText' = '';
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			

			// Bil: I got help for this one from here: http://www.regular-expressions.info/duplicatelines.html
			$answerText = (string_replaceregexp: $originalText, -find='(?<=\r\n|^)([^\r\n]*)(\r\n\\1)+(?=\r\n|$)', -replace='\\1', -ignorecase);


		?>
		
		<p style="color: blue"><b>Original Text:</b> <pre style="color: blue">[Encode_HTML: $originalText]</pre></p>
		<p style="color: red"><b>Answer:</b> <pre style="color: red">[Encode_HTML: $answerText]</pre></p>
		
		<hr />
		
		<h2>4 - Strip HTML</h2>
		
		<p>Remove all of the HTML tags from a block of text.  All opening and closing
		tags should be removed including any parameters within the tags.</p>
		
		<?LassoScript
		
			var: 'originalText' = '<b>First Name:</b> <em>John</em><br />\
			<b>Last Name:</b> <em>Doe</em><br />\
			<b>Education:<b> <em>John graduated from <a href="http://www.harvard.com"
			target="_new">Harvard University</a> with a degree in Forestry.';
			
			var: 'answerText' = '';
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
			$answerText = (string_replaceregexp: $originalText, -find='(?s)<[^<]*>', -replace='', -ignorecase);

		?>
		
		<p style="color: blue"><b>Original Text:</b> [Encode_HTML: $originalText]</p>
		<p style="color: red"><b>Answer:</b> [Encode_HTML: $answerText]</p>
		
		<hr />
		
		<h2>5 - Decorate Web URLs</h2>
		
		<p>Automatically mark up URLs which are contained within text.
		For example, the URL http://www.lassosoft.com/ should be marked
		up as <a href="http://www.lassosoft.com/">http://www.lassosoft.com</a>. 
		You should handle http:// and https:// links which contain valid
		URL characters including _-./?&amp;%#.  For this problem we can
		assume the text will not contain HTML.</p>
		
		<?LassoScript
		
			var: 'originalText' = 'Visit LassoSoft’s Web site at \
			http://www.lassosoft.com/ or write to info@lassosoft.com for \
			more information.  The Lasso Reference can be found at \
			http://reference.lassosoft.com/.';
			
			var: 'answerText' = '';
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.
			
			
			// Bil: allowed chars in a URL are here: http://www.w3.org/Addressing/URL/url-spec.txt
			$answerText = (string_replaceregexp: $originalText, -find='(?s)(http|https)://([a-z0-9:$-_@.&+\\-!*"\'(),%=;/#?]+)(\\.|\\s|\\?|\\!)', -replace='<a href="\\1://\\2">\\1://\\2</a>\\3', -ignorecase);

		?>
		
		<p style="color: blue"><b>Original Text:</b> [Encode_HTML: $originalText]</p>
		<p style="color: red"><b>Answer:</b> [Encode_HTML: $answerText]</p>
		<p style="color: red"><b>HTML Answer:</b> [$answerText]</p>

		<hr />
		
		<h2>6 - Decorate Email Addresses</h2>
		
		<p>Automatically mark up email addresses which are contained within text.
		For example, the URL info@lassosoft.com should be marked
		up as <a href="mailto:info@lassosoft.com">info@lassosoft.com</a>. 
		You should handle email addresses which contain valid
		URL characters including _-.@.  For this problem we can
		assume the text will not contain HTML.</p>
		
		<?LassoScript
		
			var: 'originalText' = 'Visit LassoSoft’s Web site at \
			http://www.lassosoft.com/ or write to info@lassosoft.com for \
			more information.  The Lasso Reference can be found at \
			http://reference.lassosoft.com/.';
			
			var: 'answerText' = '';
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.


			// Bil: using regex from here: http://www.regular-expressions.info/email.html
			$answerText = (string_replaceregexp: $originalText, -find='\\b([A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,4})\\b', -replace='<a href="mailto:\\1">\\1</a>', -ignorecase);

			
		?>
		
		<p style="color: blue"><b>Original Text:</b> [Encode_HTML: $originalText]</p>
		<p style="color: red"><b>Answer:</b> [Encode_HTML: $answerText]</p>
		<p style="color: red"><b>HTML Answer:</b> [$answerText]</p>

		<hr />
		
		<h2>7 - Wiki Style Formatting</h2>
		
		<p>Process wiki style formatting commands. The idea is that these
		commands make it easier for end-users to edit the content of the
		Web page without knowing HTML.</p>
		
		<p>Formatting - The following characters surround text which
		should be formatted in a certain way. *<b>Bold</b>*,
		_<em>Emphasised</em>_, +<u>Underlined</u>+,
		-<del>Deleted</del>-, ??<cite>Cited</cite>??,
		^<sup>Superscript</sup>^, ~<sub>Subscript</sub>~,
		{{<tt>Teletype</tt>}}.</p>
		
		<p>Headers - Lines which start with H# and a space are headers. 
		The number can range from 1 to 7.</p>
		
		<h3>H3 Header</h3>
		
		<p>Rules and Spacing - Lines with start with - and a space should be formatted as an &lt;hr />
		horizontal rule.  Blank lines (two returns) separate paragraphs.  Single returns are ignored.</p>
		
		<p>Lists - Any line which starts with a dash character - and a space is part of a list.  Any
		line which starts with a number sign # and a space is part of a numbered list. The bullet or
		number sign must be the first character in the line and must be fllowed by a space.</p>
		
		<table border="0" cellspacing="0" cellpadding="0"><tr>
			<td>- One<br />- Two<br />- Three</td>
			<td><ul><li>One</li><li>Two</li><li>Three</li></ul></td>
			</tr><tr>
			<td># One<br /># Two<br /># Three</td>
			<td><ol><li>One</li><li>Two</li><li>Three</li></ol></td>
		</tr></table>
		
		<p>Anchors - Hyperlinks can be added by specifying the link
		within square brackets.
		['[http://www.apple.com]'] links to <a
		href="http://www.apple.com">http://www.apple.com</a>.  The name
		for the link can be given after a vertical bar.
		['[http://www.apple.com|Apple Computer]']
		links to <a href="http://www.apple.com">Apple Computer</a>.  An
		anchor on the current page can be linked with ['[#anchor]'].</p>
		
		<p>Images - Images can be inserted into the page by specifying their name in
		exclamation points. !mylogo.gif! would insert the specified image as &lt;img src="mylogo.gif" />.
		Options for the image can be given after a vertical bar.  Options include left, right, or center
		for alignment and #x# to specify a size. !mylogo.gif|right|72x72! would insert the specified image
		as &lt;img src="mylogo.gif" align="right" width="72" height="72" />.</p>
		
		<p>Note that an image can be used
		in an anchor as ['[http://www.apple.com|!mylog.gif!]'] to generate &lta href="http://www.apple.com">&lt;img src="mylogo.gif" align="right" width="72" height="72" />&lt;/a>.</p>
		
		<?LassoScript
		
			var: 'originalText' =
			'[http://www.thriftyfun.com/|!http://www.thriftyfun.com/images/header/frugal_living_01.jpg|right!]\r\n\
			I found it so _unusual_ that he wanted to buy *ten*\r\n\
			rutabagas.  Then I realized he was probably going to make\r\n\
			[http://www.thriftyfun.com/tf36350727.tip.html|Confetti Soup] in his microwave.\r\n\
			\r\n\
			-\r\n\
			\r\n\
			H3 Ingredients\r\n\
			- 3 Tbsp. butter\r\n\
			- 1 cup cubed carrots\r\n\
			- 1 cup cubed rutabaga\r\n\
			- 1/2 cup chopped onion\r\n\
			- 1/2 cup chopped celery\r\n\
			- 1/2 cup broccoli crowns\r\n\
			- 1/2 cup cauliflower crowns\r\n\
			- 1/4 cup flour\r\n\
			- 1/2 tsp. salt\r\n\
			- 1/2 tsp. pepper\r\n\
			- 1/4 tsp. sugar\r\n\
			- 4 cups milk\r\n\
			- 1 cup shredded cheese\r\n\
			- 1 cup corn\r\n\
			- 1/2 cup peas\r\n\
			- 1 cup cubed ham\r\n\
			\r\n\
			H3 Directions\r\n\
			Combine first 7 ingredients (in 3 qt. casserole). Cover and\r\n\
			cook on high in microwave for 10 minutes. Stir in flour,\r\n\
			salt, pepper and sugar. Blend in milk. Heat for 16 minutes,\r\n\
			4 minutes at a time (stirring after each time). Stir in\r\n\
			remainder and heat another 4 minutes.';
			
			var: 'answerText' = '';
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.'

			// get original text
			$answerText = $originalText;

			var:'re' = (RegExp: -input=$originalText, -Find='(?im)\\[[^\\]]+\\]|![^!]+!|((\\s*\r\n\\s*){2}|(\\s*\r\\s*){2}|(\\s*\n\\s*){2})|^\\-$|^H(1|2|3|4|5|6|7)\\s+.*$|\\#\\s+.*|\\-\\s+.*|^\\-\\s+.*$|\\*[^\\*]*\\*|_[^\\_]*_|\\+[^\\+]*\\+|\\-[^\\-]*\\-|\\?\\?[^\\?]*\\?\\?|\\^[^\\^]*\\^|\\~[^\\~]*\\~|\\{\\{[^\\}]*\\}\\}');
			var:'temp' = string;
			var:'temp2' = string;
			var:'temp_trim' = string;
			var:'list' = 'none';
			var:'prev_list' = 'none';
			while: $re->find;
				$temp = $re->(matchstring);
				$temp_trim = $temp;
				$temp_trim->trim;
				// bold
				if: $temp->(beginswith:'*');
					$temp = (string_replaceregexp: $temp, -find='\\*([^\\*]*)\\*', -replace='<b>\\1</b>', -ignorecase);
					$list = 'none';
				// emphasis
				else: $temp->(beginswith:'_');
					$temp = (string_replaceregexp: $temp, -find='_([^\\_]*)_', -replace='<em>\\1</em>', -ignorecase);
					$list = 'none';
				// underline
				else: $temp->(beginswith:'+');
					$temp = (string_replaceregexp: $temp, -find='\\+([^\\+]*)\\+', -replace='<u>\\1</u>', -ignorecase);
					$list = 'none';
				// citation
				else: $temp->(beginswith:'?');
					$temp = (string_replaceregexp: $temp, -find='\\?\\?([^\\?]*)\\?\\?', -replace='<cite>\\1</cite>', -ignorecase);
					$list = 'none';
				// superscript
				else: $temp->(beginswith:'^');
					$temp = (string_replaceregexp: $temp, -find='\\^([^\\^]*)\\^', -replace='<sup>\\1</sup>', -ignorecase);
					$list = 'none';
				// subscript
				else: $temp->(beginswith:'~');
					$temp = (string_replaceregexp: $temp, -find='\\~([^\\~]*)\\~', -replace='<sub>\\1</sub>', -ignorecase);
					$list = 'none';
				// teletext
				else: $temp->(beginswith:'{{');
					$temp = (string_replaceregexp: $temp, -find='\\{\\{([^\\}]*)\\}\\}', -replace='<tt>\\1</tt>', -ignorecase);
					$list = 'none';
				// heading
				else: $temp->(beginswith:'H');
					$temp = (string_replaceregexp: $temp, -find='(?im)^H(1|2|3|4|5|6|7)\\s+(.*)$', -replace='<H\\1>\\2</H\\1>', -ignorecase);
					$list = 'none';
				// ordered list
				else: $temp->(beginswith:'#');
					if: $prev_list == 'ol';
						$temp = (string_replaceregexp: $temp, -find='(?im)\\#\\s+(.*)', -replace='<li>\\1</li>', -ignorecase);
					else;
						$temp = (string_replaceregexp: $temp, -find='(?im)\\#\\s+(.*)', -replace='<ol><li>\\1</li>', -ignorecase);
					/if;
					$list = 'ol';
				// must determine
				else: $temp->(beginswith:'-');
					// hr
					if: ($temp_trim->size == 1);
						$temp->(replace:'-','<hr>');
						$list = 'none';
					// deleted
					else: $temp->(endswith:'-');
						$temp = (string_replaceregexp: $temp, -find='\\-([^\\-]*)\\-', -replace='<del>\\1</del>', -ignorecase);
						$list = 'none';
					// unorder list
					else;
						if: $prev_list == 'ul';
							$temp = (string_replaceregexp: $temp, -find='(?im)\\-\\s+(.*)', -replace='<li>\\1</li>', -ignorecase);					
						else;
							$temp = (string_replaceregexp: $temp, -find='(?im)\\-\\s+(.*)', -replace='<ul><li>\\1</li>', -ignorecase);
						/if;
						$list = 'ul';
					/if;
				else: $temp_trim->size == 0;
					$temp += '</p><p>';
					$list = 'none';
				// link/anchor
				else: $temp->(beginswith:'[');
					$temp2 = $temp->(split:'|')->size;
					// anchor
					if: $temp->(get:2) == '#';
						// no label
						if: $temp2 == 1;
							$temp = (string_replaceregexp: $temp, -find='\\[#([^\\]]+)\\]', -replace='<a href="#\\1">\\1</a>', -ignorecase);
						// has label
						else;
							$temp = (string_replaceregexp: $temp, -find='\\[#([^\\|]+)\\|([^\\]]+)\\]', -replace='<a href="#\\1">\\2</a>', -ignorecase);
						/if;
					// link
					else;
						// no label
						if: $temp2 == 1;
							$temp = (string_replaceregexp: $temp, -find='\\[([^\\]]+)\\]', -replace='<a href="\\1">\\1</a>', -ignorecase);
						// has label
						else;
							$temp = (string_replaceregexp: $temp, -find='\\[([^\\|]+)\\|([^\\]]+)\\]', -replace='<a href="\\1">\\2</a>', -ignorecase);
						/if;
					/if;
					$list = 'none';
				/if;
				
				// images
				if: $temp->(beginswith:'!') || $temp->(beginswith:'<a');
					$temp2 = $temp->(split:'|')->size;
					// just the image path
					if: $temp2 == 1;
						$temp = (string_replaceregexp: $temp, -find='!([^!]+)!', -replace='<img src="\\1">', -ignorecase);
					// img + align
					else: $temp2 == 2;
						$temp = (string_replaceregexp: $temp, -find='!([^\\|]+)\\|([^!]+)!', -replace='<img src="\\1" align="\\2">', -ignorecase);
					// img + align + size
					else;
						$temp = (string_replaceregexp: $temp, -find='!([^\\|]+)\\|([^\\|]+)\\|([^x]+)x([^!]+)!', -replace='<img src="\\1" align="\\2" width="\\3" height="\\4">', -ignorecase);
					/if;
					$list = 'none';
				/if;

				// handle closing lists, if needed
				if: $prev_list == 'none' || $prev_list == $list;
					$re->(AppendReplacement: $temp);
				else; // closing list
					$temp = '</'+$prev_list+'>' + $temp;
					$re->(AppendReplacement: $temp);				
				/if;
				$prev_list = $list;
			/while;
			$re->AppendTail;
			$answerText = '<p>' + $re->output + '</p>';

		?>
		
		<p style="color: blue"><b>Original Text:</b> <pre style="color: blue">[Encode_HTML: $originalText]</pre></p>
		<p style="color: red"><b>Answer:</b> [Encode_HTML: $answerText]</p>
		<p style="color: red"><b>HTML Answer:</b> [$answerText]</p>
		<hr />
		
		<h2>8 - Lasso Reference Links</h2>
		
		<p>Link Lasso tag names to the Lasso Reference automatically. 
		In our documentation we always specify tag names as
		['[Field]'] with the name of the tag in
		square brackets. Container tags are specified as
		['[Records] ... [/Records]'].  Groups of tags
		are specified as ['[Link_...]'].  Command tags
		such as -Database and -Table may also be linked.  It is not necessary
		to link symbols or data types.</p>
		
		<p>A function is provided which takes a tag name and returns a link to
		the Lasso Reference.  It uses the local Lasso Reference database to determine
		if a tag name is documented or not.  If the function returns the empty
		string then no link should be provided.</p>
		
		<?LassoScript

				// [Encode_TagLink]
				// This tag helps assemble a link to the online Lasso Reference in the proper format.
				// It encodes a subset of URL characters, strips off closing container tags, and uses 
				// the tag's ID if the tag name contains certain invalid characters.
				Define_Tag: 'encode_taglink', -Required='value';
					Local: 'output' = #value;
					If: #output->(EndsWith: '...]');
						#output->(Replace: '...]', '');
					Else: (#output >> '...');
						#output = (String_ReplaceRegExp: #output, -Find=' ?\\.\\.\\..*', -Replace='');
					Else: (#output >> ' ') || #output->(BeginsWith: '-');
						Inline: -Search, 
								-Log='none', 
								-Database='ldml8_reference', 
								-Table='tags', 
								-Eq, 'tag_name'=#output, 
								-MaxRecords=1, -UseLimit, 
								-ReturnField='tag_id';
							If: (Found_Count > 0);
								#output = '@' + (Field: 'tag_id');
								//Return: '@' + (Field: 'tag_id');  // Bil: fixed this
							Else;
								Return: '';
							/If;
						/Inline;
					/If;
					#output->(Replace: '%', '%25');
					#output->(Replace: '&', '%26');
					#output->(Replace: '+', '%2b');
					#output->(Replace: '=', '%3d');
					#output->(Replace: '?', '%3f');
					#output = 'http://reference.lassosoft.com/Reference.LassoApp?' + #output;
					Return: @#output;
				/Define_Tag;
		
			var: 'originalText' = 'The Lasso Reference includes articles about every
			Lasso tag including [Field], [Records] ... [/Records], [Inline] ... [/Inline],
			[Link_...], and more.  It also has articles about inline parameter such as 
			-Search, -Add, -Update, -Database, -Table, -MaxRecords, etc.';			
			
			var: 'answerText' = '';
			
			// Insert regular expression code here.  Your answer should be
			// stored in the $answerText variable and $originalText should not
			// be modified.


			var:'re' = (RegExp: -input=$originalText, -Find='\\[[^\\]]+\\]\\s*\\.\\.\\.\\s*\\[/[^\\]]+\\]|\\[[^\\]]+\\]|\\-[a-zA-Z0-9]+');
			var:'temp' = string;
			while: $re->find;
				$temp = (encode_taglink: $re->(matchstring));
				if: $temp->size;
					$re->(AppendReplacement: '<a href="'+$temp+'">'+$re->(matchstring)+'</a>');
				else;
					$re->(AppendReplacement: $re->(matchstring));
				/if;
			/while;
			$re->AppendTail;
			$answerText = $re->output;

		?>
		
		<p style="color: blue"><b>Original Text:</b> [Encode_HTML: $originalText]</p>
		<p style="color: red"><b>Answer:</b> [Encode_HTML: $answerText]</p>
		<p style="color: red"><b>HTML Answer:</b> [$answerText]</p>		
		<hr />
		
		<p>Please send any questions about the challenge to <a
		href="mailto:challenge@lassosoft.com">challenge@lassosoft.com</a>.</p>
		
		<p>Copyright 2007 LassoSoft, LLC. All Rights Reserved.</p>

	</body>
</html>



